/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ChangePageButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sekelsta.horse_colors.entity.genetics.Genome;

@OnlyIn(value=Dist.CLIENT)
public class GeneBookScreen
extends Screen {
    private static final int linesPerPage = 14;
    private static final int lineWrapWidth = 124;
    private static final int bookWidth = 360;
    private static final int bookHeight = 192;
    private static final int pageWidth = 130;
    private static final int pageCrease = 10;
    int currPage = 0;
    private Genome genome;
    private List<List<String>> contents;
    private List<String> pages;
    private List<IReorderingProcessor> cachedPageLinesLeft = Collections.emptyList();
    private List<IReorderingProcessor> cachedPageLinesRight = Collections.emptyList();
    private int cachedPage = -1;
    private ChangePageButton buttonNextPage;
    private ChangePageButton buttonPreviousPage;
    private final boolean pageTurnSounds = true;

    public GeneBookScreen(Genome genomeIn) {
        super(NarratorChatListener.field_216868_a);
        this.genome = genomeIn;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(new ResourceLocation("horse_colors:textures/gui/book.png"));
        int x = (this.field_230708_k_ - 360) / 2;
        int y = 2;
        GeneBookScreen.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)360, (int)192, (int)512, (int)256);
        if (this.cachedPage != this.currPage) {
            this.cachedPageLinesLeft = this.cachePageLines(this.currPage);
            this.cachedPageLinesRight = this.cachePageLines(this.currPage + 1);
        }
        this.cachedPage = this.currPage;
        this.renderPage(matrixStack, this.currPage, this.cachedPageLinesLeft, this.field_230708_k_ / 2 - 130 - 10);
        if (this.getPageCount() > this.currPage + 1) {
            this.renderPage(matrixStack, this.currPage + 1, this.cachedPageLinesRight, this.field_230708_k_ / 2 + 10);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private List<IReorderingProcessor> cachePageLines(int page) {
        ITextProperties itextproperties;
        if (page < 0 || page >= this.getPageCount()) {
            itextproperties = ITextProperties.field_240651_c_;
        } else {
            String pagetext = this.getPageText(page);
            itextproperties = ITextProperties.func_240652_a_((String)pagetext);
        }
        return this.field_230712_o_.func_238425_b_(itextproperties, 124);
    }

    private void renderPage(MatrixStack matrixStack, int pagenum, List<IReorderingProcessor> cachedPageLines, int x) {
        String pageindicator = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{pagenum + 1, this.getPageCount()});
        String pagetext = this.getPageText(pagenum);
        int j1 = this.getTextWidth(pageindicator);
        this.field_230712_o_.func_238421_b_(matrixStack, pageindicator, (float)(x - j1 + 130), 18.0f, 0);
        int lines = Math.min(14, cachedPageLines.size());
        for (int i = 0; i < lines; ++i) {
            IReorderingProcessor text = cachedPageLines.get(i);
            this.field_230712_o_.func_238422_b_(matrixStack, text, (float)x, (float)(32 + i * 9), 0);
        }
    }

    protected void func_231160_c_() {
        this.contents = this.genome.getBookContents();
        this.pages = new ArrayList<String>();
        for (int ch = 0; ch < this.contents.size(); ++ch) {
            String s = "";
            int lines = 0;
            for (int ln = 0; ln < this.contents.get(ch).size(); ++ln) {
                String text = this.contents.get(ch).get(ln);
                ITextProperties itextproperties = ITextProperties.func_240652_a_((String)text);
                int wrapped = this.field_230712_o_.func_238420_b_().func_238362_b_(itextproperties, 124, Style.field_240709_b_).size();
                if (lines + wrapped > 14 && lines > 0) {
                    this.pages.add(s);
                    s = "";
                    lines = 0;
                }
                lines += wrapped;
                s = s + text + "\n";
            }
            this.pages.add(s);
        }
        this.addDoneButton();
        this.addChangePageButtons();
    }

    protected void addDoneButton() {
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, 196, 200, 20, DialogTexts.field_240632_c_, param -> this.field_230706_i_.func_147108_a((Screen)null)));
    }

    protected void addChangePageButtons() {
        int x1 = (this.field_230708_k_ - 360) / 2;
        int x2 = (this.field_230708_k_ + 360) / 2;
        int j = 2;
        int y = 159;
        this.buttonNextPage = (ChangePageButton)this.func_230480_a_((Widget)new ChangePageButton(x2 - 43 - 24, y, true, p_214159_1_ -> this.nextPage(), this.pageTurnSounds));
        this.buttonPreviousPage = (ChangePageButton)this.func_230480_a_((Widget)new ChangePageButton(x1 + 43, y, false, p_214158_1_ -> this.previousPage(), this.pageTurnSounds));
        this.updateButtons();
    }

    private int getPageCount() {
        return this.pages.size();
    }

    protected void previousPage() {
        this.currPage = Math.max(this.currPage - 2, 0);
        this.updateButtons();
    }

    protected void nextPage() {
        if (this.currPage < this.getPageCount() - 2) {
            this.currPage += 2;
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_230694_p_ = this.currPage < this.getPageCount() - 2;
        this.buttonPreviousPage.field_230694_p_ = this.currPage > 0;
    }

    private String getPageText(int pagenum) {
        if (this.pages.size() > 0) {
            return this.pages.get(pagenum);
        }
        return "";
    }

    private int getTextWidth(String text) {
        return this.field_230712_o_.func_78256_a(this.field_230712_o_.func_78260_a() ? this.field_230712_o_.func_147647_b(text) : text);
    }
}

